/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.util.Comparator;
import net.datastructures.AdaptablePriorityQueue;
import net.datastructures.Entry;
import net.datastructures.InvalidEntryException;
import net.datastructures.InvalidKeyException;
import net.datastructures.Position;
import net.datastructures.PositionList;
import net.datastructures.SortedListPriorityQueue;

public class SortedListAdaptablePriorityQueue<K, V>
extends SortedListPriorityQueue<K, V>
implements AdaptablePriorityQueue<K, V> {
    public SortedListAdaptablePriorityQueue() {
    }

    public SortedListAdaptablePriorityQueue(Comparator<K> comparator) {
        super(comparator);
    }

    public SortedListAdaptablePriorityQueue(PositionList<Entry<K, V>> positionList, Comparator<K> comparator) {
        super(positionList, comparator);
    }

    @Override
    public Entry<K, V> insert(K k, V v) throws InvalidKeyException {
        this.checkKey(k);
        LocationAwareEntry<K, V> locationAwareEntry = new LocationAwareEntry<K, V>(k, v);
        this.insertEntry(locationAwareEntry);
        locationAwareEntry.setLocation(this.actionPos);
        return locationAwareEntry;
    }

    @Override
    public Entry<K, V> remove(Entry<K, V> entry) {
        this.checkEntry(entry);
        LocationAwareEntry locationAwareEntry = (LocationAwareEntry)entry;
        Position position = locationAwareEntry.location();
        this.entries.remove(position);
        locationAwareEntry.setLocation(null);
        return locationAwareEntry;
    }

    @Override
    public K replaceKey(Entry<K, V> entry, K k) {
        this.checkKey(k);
        this.checkEntry(entry);
        LocationAwareEntry locationAwareEntry = (LocationAwareEntry)this.remove(entry);
        K k2 = locationAwareEntry.setKey(k);
        this.insertEntry(locationAwareEntry);
        locationAwareEntry.setLocation(this.actionPos);
        return k2;
    }

    @Override
    public V replaceValue(Entry<K, V> entry, V v) {
        this.checkEntry(entry);
        V v2 = ((LocationAwareEntry)entry).setValue(v);
        return v2;
    }

    protected void checkEntry(Entry entry) throws InvalidEntryException {
        if (entry == null || !(entry instanceof LocationAwareEntry)) {
            throw new InvalidEntryException("invalid entry");
        }
    }

    protected static class LocationAwareEntry<K, V>
    extends SortedListPriorityQueue.MyEntry<K, V>
    implements Entry<K, V> {
        private Position<Entry<K, V>> loc;

        public LocationAwareEntry(K k, V v) {
            super(k, v);
        }

        public LocationAwareEntry(K k, V v, Position<Entry<K, V>> position) {
            super(k, v);
            this.loc = position;
        }

        protected Position<Entry<K, V>> location() {
            return this.loc;
        }

        protected Position<Entry<K, V>> setLocation(Position<Entry<K, V>> position) {
            Position<Entry<K, V>> position2 = this.location();
            this.loc = position;
            return position2;
        }

        protected K setKey(K k) {
            Object k2 = this.getKey();
            this.k = k;
            return k2;
        }

        protected V setValue(V v) {
            Object v2 = this.getValue();
            this.v = v;
            return v2;
        }
    }
}

