/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import net.datastructures.DefaultComparator;
import net.datastructures.NodePositionList;
import net.datastructures.PositionList;

public class Sort {
    public static <E> void mergeSort(PositionList<E> positionList, Comparator<E> comparator) {
        int n = positionList.size();
        if (n < 2) {
            return;
        }
        NodePositionList<E> nodePositionList = new NodePositionList<E>();
        NodePositionList<E> nodePositionList2 = new NodePositionList<E>();
        for (int i = 0; i < n / 2; ++i) {
            nodePositionList.addLast(positionList.remove(positionList.first()));
        }
        while (!positionList.isEmpty()) {
            nodePositionList2.addLast(positionList.remove(positionList.first()));
        }
        Sort.mergeSort(nodePositionList, comparator);
        Sort.mergeSort(nodePositionList2, comparator);
        Sort.merge(nodePositionList, nodePositionList2, comparator, positionList);
    }

    public static <E> void merge(PositionList<E> positionList, PositionList<E> positionList2, Comparator<E> comparator, PositionList<E> positionList3) {
        while (!positionList.isEmpty() && !positionList2.isEmpty()) {
            if (comparator.compare(positionList.first().element(), positionList2.first().element()) <= 0) {
                positionList3.addLast(positionList.remove(positionList.first()));
                continue;
            }
            positionList3.addLast(positionList2.remove(positionList2.first()));
        }
        while (!positionList.isEmpty()) {
            positionList3.addLast(positionList.remove(positionList.first()));
        }
        while (!positionList2.isEmpty()) {
            positionList3.addLast(positionList2.remove(positionList2.first()));
        }
    }

    public static <E> void mergeSort(E[] EArray, Comparator<E> comparator) {
        Object[] objectArray = new Object[EArray.length];
        System.arraycopy(EArray, 0, objectArray, 0, objectArray.length);
        Object[] objectArray2 = new Object[objectArray.length];
        int n = objectArray.length;
        for (int i = 1; i < n; i *= 2) {
            for (int j = 0; j < n; j += 2 * i) {
                Sort.merge(objectArray, objectArray2, comparator, j, i);
            }
            Object[] objectArray3 = objectArray;
            objectArray = objectArray2;
            objectArray2 = objectArray3;
        }
        System.arraycopy(objectArray, 0, EArray, 0, objectArray.length);
    }

    protected static <E> void merge(E[] EArray, E[] EArray2, Comparator<E> comparator, int n, int n2) {
        int n3 = n;
        int n4 = Math.min(n + n2, EArray.length);
        int n5 = Math.min(n + 2 * n2, EArray.length);
        int n6 = n + n2;
        int n7 = n;
        while (n3 < n4 && n6 < n5) {
            if (comparator.compare(EArray[n3], EArray[n6]) <= 0) {
                EArray2[n7++] = EArray[n3++];
                continue;
            }
            EArray2[n7++] = EArray[n6++];
        }
        if (n3 < n4) {
            System.arraycopy(EArray, n3, EArray2, n7, n4 - n3);
        } else if (n6 < n5) {
            System.arraycopy(EArray, n6, EArray2, n7, n5 - n6);
        }
    }

    public static <E> void quickSort(PositionList<E> positionList, Comparator<E> comparator) {
        if (positionList.size() <= 1) {
            return;
        }
        E e = positionList.remove(positionList.last());
        NodePositionList nodePositionList = new NodePositionList();
        NodePositionList nodePositionList2 = new NodePositionList();
        NodePositionList nodePositionList3 = new NodePositionList();
        while (!positionList.isEmpty()) {
            E e2 = positionList.remove(positionList.first());
            if (comparator.compare(e2, e) < 0) {
                nodePositionList.addFirst(e2);
                continue;
            }
            if (comparator.compare(e2, e) == 0) {
                nodePositionList2.addFirst(e2);
                continue;
            }
            nodePositionList3.addFirst(e2);
        }
        Sort.quickSort(nodePositionList, comparator);
        Sort.quickSort(nodePositionList3, comparator);
        while (!nodePositionList.isEmpty()) {
            positionList.addLast(nodePositionList.remove(nodePositionList.first()));
        }
        while (!nodePositionList2.isEmpty()) {
            positionList.addLast(nodePositionList2.remove(nodePositionList2.first()));
        }
        positionList.addLast(e);
        while (!nodePositionList3.isEmpty()) {
            positionList.addLast(nodePositionList3.remove(nodePositionList3.first()));
        }
    }

    public static <E> void quickSort(E[] EArray, Comparator<E> comparator) {
        if (EArray.length < 2) {
            return;
        }
        Sort.quickSortStep(EArray, comparator, 0, EArray.length - 1);
    }

    private static <E> void quickSortStep(E[] EArray, Comparator<E> comparator, int n, int n2) {
        E e;
        if (n >= n2) {
            return;
        }
        E e2 = EArray[n2];
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            while (n3 <= n4 && comparator.compare(EArray[n3], e2) <= 0) {
                ++n3;
            }
            while (n4 >= n3 && comparator.compare(EArray[n4], e2) >= 0) {
                --n4;
            }
            if (n3 >= n4) continue;
            e = EArray[n4];
            EArray[n4] = EArray[n3];
            EArray[n3] = e;
        }
        e = EArray[n2];
        EArray[n2] = EArray[n3];
        EArray[n3] = e;
        Sort.quickSortStep(EArray, comparator, n, n3 - 1);
        Sort.quickSortStep(EArray, comparator, n3 + 1, n2);
    }

    public static void main(String[] stringArray) throws IOException {
        String string;
        Sort.out("Start your engines...");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        Random random = new Random();
        DefaultComparator defaultComparator = new DefaultComparator();
        Sort.out("Enter number of elements:");
        String string2 = bufferedReader.readLine();
        int n = new Integer(string2);
        Integer[] integerArray = new Integer[n];
        Integer[] integerArray2 = new Integer[n];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        do {
            NodePositionList<Integer> nodePositionList = new NodePositionList<Integer>();
            NodePositionList<Integer> nodePositionList2 = new NodePositionList<Integer>();
            for (int i = 0; i < n; ++i) {
                int n2 = random.nextInt(100);
                integerArray[i] = new Integer(n2);
                integerArray2[i] = new Integer(n2);
                nodePositionList.addLast(new Integer(n2));
                nodePositionList2.addLast(new Integer(n2));
            }
            Sort.out("Array-Based Sorting");
            Sort.out("Before: " + Arrays.asList(integerArray));
            long l = System.currentTimeMillis();
            Sort.mergeSort(integerArray, defaultComparator);
            f = (float)(System.currentTimeMillis() - l) / 1000.0f;
            Sort.out("MSort:  " + Arrays.asList(integerArray));
            String string3 = Arrays.asList(integerArray).toString();
            l = System.currentTimeMillis();
            Sort.quickSort(integerArray2, defaultComparator);
            f2 = (float)(System.currentTimeMillis() - l) / 1000.0f;
            Sort.out("QSort:  " + Arrays.asList(integerArray2));
            if (!string3.equals(Arrays.asList(integerArray2).toString())) {
                System.out.println("sorts produced different results!");
                System.exit(1);
            }
            Sort.out("List-Based Sorting");
            l = System.currentTimeMillis();
            Sort.mergeSort(nodePositionList, defaultComparator);
            Sort.out("MSort:  " + nodePositionList);
            f3 = (float)(System.currentTimeMillis() - l) / 1000.0f;
            if (!string3.equals(((Object)nodePositionList).toString())) {
                System.out.println("sorts produced different results!");
                System.exit(1);
            }
            l = System.currentTimeMillis();
            Sort.quickSort(nodePositionList2, defaultComparator);
            Sort.out("QSort:  " + nodePositionList2);
            f4 = (float)(System.currentTimeMillis() - l) / 1000.0f;
            if (!string3.equals(((Object)nodePositionList2).toString())) {
                System.out.println("sorts produced different results!");
                System.exit(1);
            }
            Sort.out("Times (in seconds)");
            Sort.out("Array-Based");
            Sort.out("MSort:  " + f);
            Sort.out("QSort:  " + f2);
            Sort.out("List-Based");
            Sort.out("MSort:  " + f3);
            Sort.out("QSort:  " + f4);
            Sort.out("Type 'e' to end ...");
        } while ((string = bufferedReader.readLine()).equals(""));
    }

    private static void out(String string) {
        System.out.println(string);
    }
}

