/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.util.Comparator;
import net.datastructures.BTNode;
import net.datastructures.BTPosition;
import net.datastructures.BinarySearchTree;
import net.datastructures.Dictionary;
import net.datastructures.Entry;
import net.datastructures.InvalidEntryException;
import net.datastructures.InvalidKeyException;
import net.datastructures.Position;

public class RBTree<K, V>
extends BinarySearchTree<K, V>
implements Dictionary<K, V> {
    public RBTree() {
    }

    public RBTree(Comparator<K> comparator) {
        super(comparator);
    }

    @Override
    protected BTPosition<Entry<K, V>> createNode(Entry<K, V> entry, BTPosition<Entry<K, V>> bTPosition, BTPosition<Entry<K, V>> bTPosition2, BTPosition<Entry<K, V>> bTPosition3) {
        return new RBNode<K, V>(entry, bTPosition, bTPosition2, bTPosition3);
    }

    @Override
    public Entry<K, V> insert(K k, V v) throws InvalidKeyException {
        Entry<K, V> entry = super.insert(k, v);
        Position position = this.actionPos;
        this.setRed(position);
        if (this.isRoot(position)) {
            this.setBlack(position);
        } else {
            this.remedyDoubleRed(position);
        }
        return entry;
    }

    protected void remedyDoubleRed(Position<Entry<K, V>> position) {
        Position<Entry<K, V>> position2 = this.parent(position);
        if (this.isRoot(position2)) {
            return;
        }
        if (!this.isPosRed(position2)) {
            return;
        }
        if (!this.isPosRed(this.sibling(position2))) {
            position2 = this.restructure(position);
            this.setBlack(position2);
            this.setRed(this.left(position2));
            this.setRed(this.right(position2));
        } else {
            this.setBlack(position2);
            this.setBlack(this.sibling(position2));
            Position<Entry<K, V>> position3 = this.parent(position2);
            if (this.isRoot(position3)) {
                return;
            }
            this.setRed(position3);
            this.remedyDoubleRed(position3);
        }
    }

    @Override
    public Entry<K, V> remove(Entry<K, V> entry) throws InvalidEntryException {
        Entry<K, V> entry2 = super.remove(entry);
        Position position = this.actionPos;
        if (entry2 != null) {
            if (this.wasParentRed(position) || this.isRoot(position) || this.isPosRed(position)) {
                this.setBlack(position);
            } else {
                this.remedyDoubleBlack(position);
            }
        }
        return entry2;
    }

    protected void remedyDoubleBlack(Position<Entry<K, V>> position) {
        Position<Entry<K, V>> position2 = this.parent(position);
        Position<Entry<K, V>> position3 = this.sibling(position);
        if (!this.isPosRed(position3)) {
            Position<Entry<K, V>> position4 = this.redChild(position3);
            if (this.hasRedChild(position3)) {
                boolean bl = this.isPosRed(position2);
                position4 = this.restructure(position4);
                this.setColor(position4, bl);
                this.setBlack(position);
                this.setBlack(this.left(position4));
                this.setBlack(this.right(position4));
                return;
            }
            this.setBlack(position);
            this.setRed(position3);
            if (!this.isPosRed(position2)) {
                if (!this.isRoot(position2)) {
                    this.remedyDoubleBlack(position2);
                }
                return;
            }
            this.setBlack(position2);
            return;
        }
        Position<Entry<K, V>> position5 = position3 == this.right(position2) ? this.right(position3) : this.left(position3);
        this.restructure(position5);
        this.setBlack(position3);
        this.setRed(position2);
        this.remedyDoubleBlack(position);
    }

    protected boolean isPosRed(Position<Entry<K, V>> position) {
        return ((RBNode)position).isRed();
    }

    private boolean wasParentRed(Position<Entry<K, V>> position) {
        return !this.isRoot(position) && !this.isPosRed(position) && !this.isPosRed(this.parent(position)) && (this.isExternal(this.sibling(position)) || this.hasTwoExternalChildren(this.sibling(position)) && this.isPosRed(this.sibling(position)));
    }

    private boolean hasTwoExternalChildren(Position<Entry<K, V>> position) {
        return this.isExternal(this.left(position)) && this.isExternal(this.right(position));
    }

    protected void setRed(Position<Entry<K, V>> position) {
        ((RBNode)position).makeRed();
    }

    protected void setBlack(Position<Entry<K, V>> position) {
        ((RBNode)position).makeBlack();
    }

    protected void setColor(Position<Entry<K, V>> position, boolean bl) {
        ((RBNode)position).setColor(bl);
    }

    protected Position<Entry<K, V>> redChild(Position<Entry<K, V>> position) {
        Position<Entry<K, V>> position2 = this.left(position);
        if (this.isPosRed(position2)) {
            return position2;
        }
        position2 = this.right(position);
        if (this.isPosRed(position2)) {
            return position2;
        }
        return null;
    }

    protected boolean hasRedChild(Position<Entry<K, V>> position) {
        return this.isPosRed(this.left(position)) || this.isPosRed(this.right(position));
    }

    protected boolean swapColor(Position<Entry<K, V>> position, Position<Entry<K, V>> position2) {
        boolean bl = false;
        if (this.isPosRed(position) && !this.isPosRed(position2)) {
            bl = true;
            this.setBlack(position);
            this.setRed(position2);
        } else if (!this.isPosRed(position) && this.isPosRed(position2)) {
            this.setBlack(position2);
            this.setRed(position);
        }
        return bl;
    }

    protected void swap(Position<Entry<K, V>> position, Position<Entry<K, V>> position2) {
        this.swapColor(position2, position);
        this.swapElements(position, position2);
    }

    protected static class RBNode<K, V>
    extends BTNode<Entry<K, V>> {
        protected boolean isRed;

        RBNode() {
        }

        RBNode(Entry<K, V> entry, BTPosition<Entry<K, V>> bTPosition, BTPosition<Entry<K, V>> bTPosition2, BTPosition<Entry<K, V>> bTPosition3) {
            super(entry, bTPosition, bTPosition2, bTPosition3);
            this.isRed = false;
        }

        public boolean isRed() {
            return this.isRed;
        }

        public void makeRed() {
            this.isRed = true;
        }

        public void makeBlack() {
            this.isRed = false;
        }

        public void setColor(boolean bl) {
            this.isRed = bl;
        }
    }
}

