/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import net.datastructures.EmptyStackException;
import net.datastructures.Node;
import net.datastructures.Stack;

public class NodeStack<E>
implements Stack<E> {
    protected Node<E> top = null;
    protected int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.top == null;
    }

    @Override
    public void push(E e) {
        Node<E> node = new Node<E>(e, this.top);
        this.top = node;
        ++this.size;
    }

    @Override
    public E top() throws EmptyStackException {
        if (this.isEmpty()) {
            throw new EmptyStackException("Stack is empty.");
        }
        return this.top.getElement();
    }

    @Override
    public E pop() throws EmptyStackException {
        if (this.isEmpty()) {
            throw new EmptyStackException("Stack is empty.");
        }
        E e = this.top.getElement();
        this.top = this.top.getNext();
        --this.size;
        return e;
    }

    public String toString() {
        Node<E> node = null;
        String string = "[";
        int n = this.size();
        if (n > 0) {
            node = this.top;
            string = string + node.getElement();
        }
        if (n > 1) {
            for (int i = 1; i <= n - 1; ++i) {
                node = node.getNext();
                string = string + ", " + node.getElement();
            }
        }
        string = string + "]";
        return string;
    }

    public static void status(Stack stack, String string, Object object) {
        System.out.println("---------------------------------");
        System.out.println(string);
        System.out.println("Returned: " + object);
        String string2 = stack.isEmpty() ? "empty" : "not empty";
        System.out.println("size = " + stack.size() + ", " + string2);
        System.out.println("Stack: " + stack);
    }

    public static void main(String[] stringArray) {
        NodeStack<Integer> nodeStack = new NodeStack<Integer>();
        NodeStack.status(nodeStack, "New empty stack", null);
        nodeStack.push(5);
        NodeStack.status(nodeStack, "push(5)", null);
        nodeStack.push(3);
        NodeStack.status(nodeStack, "push(3)", null);
        nodeStack.push(7);
        NodeStack.status(nodeStack, "push(7)", null);
        Object e = nodeStack.pop();
        NodeStack.status(nodeStack, "pop()", e);
        nodeStack.push(9);
        NodeStack.status(nodeStack, "push(9)", null);
        e = nodeStack.pop();
        NodeStack.status(nodeStack, "pop()", e);
        e = nodeStack.top();
        NodeStack.status(nodeStack, "top()", e);
    }
}

