/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import net.datastructures.EmptyQueueException;
import net.datastructures.Node;
import net.datastructures.Queue;

public class NodeQueue<E>
implements Queue<E> {
    protected Node<E> head = null;
    protected Node<E> tail = null;
    protected int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null && this.tail == null;
    }

    @Override
    public void enqueue(E e) {
        Node node = new Node();
        node.setElement(e);
        node.setNext(null);
        if (this.size == 0) {
            this.head = node;
        } else {
            this.tail.setNext(node);
        }
        this.tail = node;
        ++this.size;
    }

    @Override
    public E front() throws EmptyQueueException {
        if (this.size == 0) {
            throw new EmptyQueueException("Queue is empty.");
        }
        return this.head.getElement();
    }

    @Override
    public E dequeue() throws EmptyQueueException {
        if (this.size == 0) {
            throw new EmptyQueueException("Queue is empty.");
        }
        E e = this.head.getElement();
        this.head = this.head.getNext();
        --this.size;
        if (this.size == 0) {
            this.tail = null;
        }
        return e;
    }

    public String toString() {
        String string = "";
        string = string + "(";
        if (!this.isEmpty()) {
            Node<E> node = this.head;
            do {
                string = string + node.getElement();
                if (node == this.tail) continue;
                string = string + ", ";
            } while ((node = node.getNext()) != null);
        }
        string = string + ")";
        return string;
    }

    public static void status(Queue queue, String string, Object object) {
        System.out.println("---------------------------------");
        System.out.println(string);
        System.out.println("Returned: " + object);
        String string2 = queue.isEmpty() ? "empty" : "not empty";
        System.out.println("size = " + queue.size() + ", " + string2);
        System.out.println("Queue: " + queue);
    }

    public static void main(String[] stringArray) {
        NodeQueue<Integer> nodeQueue = new NodeQueue<Integer>();
        NodeQueue.status(nodeQueue, "New empty queue", null);
        nodeQueue.enqueue(5);
        NodeQueue.status(nodeQueue, "enqueue(5)", null);
        nodeQueue.enqueue(3);
        NodeQueue.status(nodeQueue, "enqueue(3)", null);
        nodeQueue.enqueue(7);
        NodeQueue.status(nodeQueue, "enqueue(7)", null);
        Object e = nodeQueue.dequeue();
        NodeQueue.status(nodeQueue, "dequeue()", e);
        nodeQueue.enqueue(9);
        NodeQueue.status(nodeQueue, "enqueue(9)", null);
        e = nodeQueue.dequeue();
        NodeQueue.status(nodeQueue, "dequeue()", e);
        e = nodeQueue.front();
        NodeQueue.status(nodeQueue, "front()", e);
    }
}

