/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.util.Iterator;
import net.datastructures.BoundaryViolationException;
import net.datastructures.DNode;
import net.datastructures.ElementIterator;
import net.datastructures.EmptyListException;
import net.datastructures.InvalidPositionException;
import net.datastructures.Position;
import net.datastructures.PositionList;

public class NodePositionList<E>
implements PositionList<E> {
    protected int numElts = 0;
    protected DNode<E> header = new DNode<Object>(null, null, null);
    protected DNode<E> trailer = new DNode<Object>(this.header, null, null);

    public NodePositionList() {
        this.header.setNext(this.trailer);
    }

    protected DNode<E> checkPosition(Position<E> position) throws InvalidPositionException {
        if (position == null) {
            throw new InvalidPositionException("Null position passed to NodeList");
        }
        if (position == this.header) {
            throw new InvalidPositionException("The header node is not a valid position");
        }
        if (position == this.trailer) {
            throw new InvalidPositionException("The trailer node is not a valid position");
        }
        try {
            DNode dNode = (DNode)position;
            if (dNode.getPrev() == null || dNode.getNext() == null) {
                throw new InvalidPositionException("Position does not belong to a valid NodeList");
            }
            return dNode;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPositionException("Position is of wrong type for this list");
        }
    }

    @Override
    public int size() {
        return this.numElts;
    }

    @Override
    public boolean isEmpty() {
        return this.numElts == 0;
    }

    @Override
    public Position<E> first() throws EmptyListException {
        if (this.isEmpty()) {
            throw new EmptyListException("List is empty");
        }
        return this.header.getNext();
    }

    @Override
    public Position<E> last() throws EmptyListException {
        if (this.isEmpty()) {
            throw new EmptyListException("List is empty");
        }
        return this.trailer.getPrev();
    }

    @Override
    public Position<E> prev(Position<E> position) throws InvalidPositionException, BoundaryViolationException {
        DNode<E> dNode = this.checkPosition(position);
        DNode<E> dNode2 = dNode.getPrev();
        if (dNode2 == this.header) {
            throw new BoundaryViolationException("Cannot advance past the beginning of the list");
        }
        return dNode2;
    }

    @Override
    public Position<E> next(Position<E> position) throws InvalidPositionException, BoundaryViolationException {
        DNode<E> dNode = this.checkPosition(position);
        DNode<E> dNode2 = dNode.getNext();
        if (dNode2 == this.trailer) {
            throw new BoundaryViolationException("Cannot advance past the end of the list");
        }
        return dNode2;
    }

    @Override
    public void addBefore(Position<E> position, E e) throws InvalidPositionException {
        DNode<E> dNode = this.checkPosition(position);
        ++this.numElts;
        DNode<E> dNode2 = new DNode<E>(dNode.getPrev(), dNode, e);
        dNode.getPrev().setNext(dNode2);
        dNode.setPrev(dNode2);
    }

    @Override
    public void addAfter(Position<E> position, E e) throws InvalidPositionException {
        DNode<E> dNode = this.checkPosition(position);
        ++this.numElts;
        DNode<E> dNode2 = new DNode<E>(dNode, dNode.getNext(), e);
        dNode.getNext().setPrev(dNode2);
        dNode.setNext(dNode2);
    }

    @Override
    public void addFirst(E e) {
        ++this.numElts;
        DNode<E> dNode = new DNode<E>(this.header, this.header.getNext(), e);
        this.header.getNext().setPrev(dNode);
        this.header.setNext(dNode);
    }

    @Override
    public void addLast(E e) {
        ++this.numElts;
        DNode<E> dNode = this.trailer.getPrev();
        DNode<E> dNode2 = new DNode<E>(dNode, this.trailer, e);
        dNode.setNext(dNode2);
        this.trailer.setPrev(dNode2);
    }

    @Override
    public E remove(Position<E> position) throws InvalidPositionException {
        DNode dNode = this.checkPosition(position);
        --this.numElts;
        DNode<E> dNode2 = dNode.getPrev();
        DNode<E> dNode3 = dNode.getNext();
        dNode2.setNext(dNode3);
        dNode3.setPrev(dNode2);
        E e = dNode.element();
        dNode.setNext(null);
        dNode.setPrev(null);
        return e;
    }

    @Override
    public E set(Position<E> position, E e) throws InvalidPositionException {
        DNode<E> dNode = this.checkPosition(position);
        E e2 = dNode.element();
        dNode.setElement(e);
        return e2;
    }

    @Override
    public Iterator<E> iterator() {
        return new ElementIterator(this);
    }

    @Override
    public Iterable<Position<E>> positions() {
        NodePositionList<Position<Position<E>>> nodePositionList = new NodePositionList<Position<Position<E>>>();
        if (!this.isEmpty()) {
            Position<E> position = this.first();
            while (true) {
                nodePositionList.addLast(position);
                if (position == this.last()) break;
                position = this.next(position);
            }
        }
        return nodePositionList;
    }

    public boolean isFirst(Position<E> position) throws InvalidPositionException {
        DNode<E> dNode = this.checkPosition(position);
        return dNode.getPrev() == this.header;
    }

    public boolean isLast(Position<E> position) throws InvalidPositionException {
        DNode<E> dNode = this.checkPosition(position);
        return dNode.getNext() == this.trailer;
    }

    public void swapElements(Position<E> position, Position<E> position2) throws InvalidPositionException {
        DNode<E> dNode = this.checkPosition(position);
        DNode<E> dNode2 = this.checkPosition(position2);
        E e = dNode.element();
        dNode.setElement(dNode2.element());
        dNode2.setElement(e);
    }

    public static <E> String forEachToString(PositionList<E> positionList) {
        String string = "[";
        int n = positionList.size();
        for (E e : positionList) {
            string = string + e;
            if (--n <= 0) continue;
            string = string + ", ";
        }
        string = string + "]";
        return string;
    }

    public static <E> String toString(PositionList<E> positionList) {
        Iterator<E> iterator = positionList.iterator();
        String string = "[";
        while (iterator.hasNext()) {
            string = string + iterator.next();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        string = string + "]";
        return string;
    }

    public String toString() {
        return NodePositionList.toString(this);
    }
}

