/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import net.datastructures.DLNode;
import net.datastructures.Deque;
import net.datastructures.EmptyDequeException;

public class NodeDeque<E>
implements Deque<E> {
    protected DLNode<E> header = new DLNode();
    protected DLNode<E> trailer = new DLNode();
    protected int size;

    public NodeDeque() {
        this.header.setNext(this.trailer);
        this.trailer.setPrev(this.header);
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public E getFirst() throws EmptyDequeException {
        if (this.isEmpty()) {
            throw new EmptyDequeException("Deque is empty.");
        }
        return this.header.getNext().getElement();
    }

    @Override
    public E getLast() throws EmptyDequeException {
        if (this.isEmpty()) {
            throw new EmptyDequeException("Deque is empty.");
        }
        return this.trailer.getPrev().getElement();
    }

    @Override
    public void addFirst(E e) {
        DLNode<E> dLNode = this.header.getNext();
        DLNode<E> dLNode2 = new DLNode<E>(e, this.header, dLNode);
        dLNode.setPrev(dLNode2);
        this.header.setNext(dLNode2);
        ++this.size;
    }

    @Override
    public void addLast(E e) {
        DLNode<E> dLNode = this.trailer.getPrev();
        DLNode<E> dLNode2 = new DLNode<E>(e, dLNode, this.trailer);
        dLNode.setNext(dLNode2);
        this.trailer.setPrev(dLNode2);
        ++this.size;
    }

    @Override
    public E removeFirst() throws EmptyDequeException {
        if (this.isEmpty()) {
            throw new EmptyDequeException("Deque is empty.");
        }
        DLNode<E> dLNode = this.header.getNext();
        E e = dLNode.getElement();
        DLNode<E> dLNode2 = dLNode.getNext();
        this.header.setNext(dLNode2);
        dLNode2.setPrev(this.header);
        --this.size;
        return e;
    }

    @Override
    public E removeLast() throws EmptyDequeException {
        if (this.isEmpty()) {
            throw new EmptyDequeException("Deque is empty.");
        }
        DLNode<E> dLNode = this.trailer.getPrev();
        E e = dLNode.getElement();
        DLNode<E> dLNode2 = dLNode.getPrev();
        this.trailer.setPrev(dLNode2);
        dLNode2.setNext(this.trailer);
        --this.size;
        return e;
    }
}

