/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.util.Iterator;
import net.datastructures.BoundaryViolationException;
import net.datastructures.EmptyTreeException;
import net.datastructures.InvalidPositionException;
import net.datastructures.NodePositionList;
import net.datastructures.NonEmptyTreeException;
import net.datastructures.Position;
import net.datastructures.PositionList;
import net.datastructures.Tree;
import net.datastructures.TreeNode;
import net.datastructures.TreePosition;

public class LinkedTree<E>
implements Tree<E> {
    protected TreePosition<E> root = null;
    protected int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isInternal(Position<E> position) throws InvalidPositionException {
        return !this.isExternal(position);
    }

    @Override
    public boolean isExternal(Position<E> position) throws InvalidPositionException {
        TreePosition<E> treePosition = this.checkPosition(position);
        return treePosition.getChildren() == null || treePosition.getChildren().isEmpty();
    }

    @Override
    public boolean isRoot(Position<E> position) throws InvalidPositionException {
        this.checkPosition(position);
        return position == this.root();
    }

    @Override
    public Position<E> root() throws EmptyTreeException {
        if (this.root == null) {
            throw new EmptyTreeException("The tree is empty");
        }
        return this.root;
    }

    @Override
    public Position<E> parent(Position<E> position) throws InvalidPositionException, BoundaryViolationException {
        TreePosition<E> treePosition = this.checkPosition(position);
        TreePosition<E> treePosition2 = treePosition.getParent();
        if (treePosition2 == null) {
            throw new BoundaryViolationException("No parent");
        }
        return treePosition2;
    }

    @Override
    public Iterable<Position<E>> children(Position<E> position) throws InvalidPositionException {
        TreePosition<E> treePosition = this.checkPosition(position);
        if (this.isExternal(position)) {
            throw new InvalidPositionException("External nodes have no children");
        }
        return treePosition.getChildren();
    }

    @Override
    public Iterable<Position<E>> positions() {
        NodePositionList<Position<E>> nodePositionList = new NodePositionList<Position<E>>();
        if (this.size != 0) {
            this.preorderPositions(this.root(), nodePositionList);
        }
        return nodePositionList;
    }

    @Override
    public Iterator<E> iterator() {
        Iterable<Position<E>> iterable = this.positions();
        NodePositionList<E> nodePositionList = new NodePositionList<E>();
        for (Position<E> position : iterable) {
            nodePositionList.addLast(position.element());
        }
        return nodePositionList.iterator();
    }

    @Override
    public E replace(Position<E> position, E e) throws InvalidPositionException {
        TreePosition<E> treePosition = this.checkPosition(position);
        E e2 = position.element();
        treePosition.setElement(e);
        return e2;
    }

    public Position<E> addRoot(E e) throws NonEmptyTreeException {
        if (!this.isEmpty()) {
            throw new NonEmptyTreeException("Tree already has a root");
        }
        this.size = 1;
        this.root = this.createNode(e, null, null);
        return this.root;
    }

    public void swapElements(Position<E> position, Position<E> position2) throws InvalidPositionException {
        TreePosition<E> treePosition = this.checkPosition(position);
        TreePosition<E> treePosition2 = this.checkPosition(position2);
        E e = position2.element();
        treePosition2.setElement(position.element());
        treePosition.setElement(e);
    }

    protected TreePosition<E> checkPosition(Position<E> position) throws InvalidPositionException {
        if (position == null || !(position instanceof TreePosition)) {
            throw new InvalidPositionException("The position is invalid");
        }
        return (TreePosition)position;
    }

    protected TreePosition<E> createNode(E e, TreePosition<E> treePosition, PositionList<Position<E>> positionList) {
        return new TreeNode<E>(e, treePosition, positionList);
    }

    protected void preorderPositions(Position<E> position, PositionList<Position<E>> positionList) throws InvalidPositionException {
        positionList.addLast(position);
        for (Position<E> position2 : this.children(position)) {
            this.preorderPositions(position2, positionList);
        }
    }
}

