/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.util.Iterator;
import net.datastructures.BTNode;
import net.datastructures.BTPosition;
import net.datastructures.BinaryTree;
import net.datastructures.BoundaryViolationException;
import net.datastructures.EmptyTreeException;
import net.datastructures.InvalidPositionException;
import net.datastructures.NodePositionList;
import net.datastructures.NonEmptyTreeException;
import net.datastructures.Position;
import net.datastructures.PositionList;

public class LinkedBinaryTree<E>
implements BinaryTree<E> {
    protected BTPosition<E> root = null;
    protected int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isInternal(Position<E> position) throws InvalidPositionException {
        this.checkPosition(position);
        return this.hasLeft(position) || this.hasRight(position);
    }

    @Override
    public boolean isExternal(Position<E> position) throws InvalidPositionException {
        return !this.isInternal(position);
    }

    @Override
    public boolean isRoot(Position<E> position) throws InvalidPositionException {
        this.checkPosition(position);
        return position == this.root();
    }

    @Override
    public boolean hasLeft(Position<E> position) throws InvalidPositionException {
        BTPosition<E> bTPosition = this.checkPosition(position);
        return bTPosition.getLeft() != null;
    }

    @Override
    public boolean hasRight(Position<E> position) throws InvalidPositionException {
        BTPosition<E> bTPosition = this.checkPosition(position);
        return bTPosition.getRight() != null;
    }

    @Override
    public Position<E> root() throws EmptyTreeException {
        if (this.root == null) {
            throw new EmptyTreeException("The tree is empty");
        }
        return this.root;
    }

    @Override
    public Position<E> left(Position<E> position) throws InvalidPositionException, BoundaryViolationException {
        BTPosition<E> bTPosition = this.checkPosition(position);
        BTPosition<E> bTPosition2 = bTPosition.getLeft();
        if (bTPosition2 == null) {
            throw new BoundaryViolationException("No left child");
        }
        return bTPosition2;
    }

    @Override
    public Position<E> right(Position<E> position) throws InvalidPositionException, BoundaryViolationException {
        BTPosition<E> bTPosition = this.checkPosition(position);
        BTPosition<E> bTPosition2 = bTPosition.getRight();
        if (bTPosition2 == null) {
            throw new BoundaryViolationException("No right child");
        }
        return bTPosition2;
    }

    @Override
    public Position<E> parent(Position<E> position) throws InvalidPositionException, BoundaryViolationException {
        BTPosition<E> bTPosition = this.checkPosition(position);
        BTPosition<E> bTPosition2 = bTPosition.getParent();
        if (bTPosition2 == null) {
            throw new BoundaryViolationException("No parent");
        }
        return bTPosition2;
    }

    @Override
    public Iterable<Position<E>> children(Position<E> position) throws InvalidPositionException {
        NodePositionList<Position<Position<E>>> nodePositionList = new NodePositionList<Position<Position<E>>>();
        if (this.hasLeft(position)) {
            nodePositionList.addLast(this.left(position));
        }
        if (this.hasRight(position)) {
            nodePositionList.addLast(this.right(position));
        }
        return nodePositionList;
    }

    @Override
    public Iterable<Position<E>> positions() {
        NodePositionList<Position<E>> nodePositionList = new NodePositionList<Position<E>>();
        if (this.size != 0) {
            this.preorderPositions(this.root(), nodePositionList);
        }
        return nodePositionList;
    }

    @Override
    public Iterator<E> iterator() {
        Iterable<Position<E>> iterable = this.positions();
        NodePositionList<E> nodePositionList = new NodePositionList<E>();
        for (Position<E> position : iterable) {
            nodePositionList.addLast(position.element());
        }
        return nodePositionList.iterator();
    }

    @Override
    public E replace(Position<E> position, E e) throws InvalidPositionException {
        BTPosition<E> bTPosition = this.checkPosition(position);
        E e2 = position.element();
        bTPosition.setElement(e);
        return e2;
    }

    public Position<E> sibling(Position<E> position) throws InvalidPositionException, BoundaryViolationException {
        BTPosition<E> bTPosition;
        BTPosition<E> bTPosition2;
        BTPosition<E> bTPosition3 = this.checkPosition(position);
        BTPosition<E> bTPosition4 = bTPosition3.getParent();
        if (bTPosition4 != null && (bTPosition2 = (bTPosition = bTPosition4.getLeft()) == bTPosition3 ? bTPosition4.getRight() : bTPosition4.getLeft()) != null) {
            return bTPosition2;
        }
        throw new BoundaryViolationException("No sibling");
    }

    public Position<E> addRoot(E e) throws NonEmptyTreeException {
        if (!this.isEmpty()) {
            throw new NonEmptyTreeException("Tree already has a root");
        }
        this.size = 1;
        this.root = this.createNode(e, null, null, null);
        return this.root;
    }

    public Position<E> insertLeft(Position<E> position, E e) throws InvalidPositionException {
        BTPosition<E> bTPosition = this.checkPosition(position);
        BTPosition<E> bTPosition2 = bTPosition.getLeft();
        if (bTPosition2 != null) {
            throw new InvalidPositionException("Node already has a left child");
        }
        BTPosition<E> bTPosition3 = this.createNode(e, bTPosition, null, null);
        bTPosition.setLeft(bTPosition3);
        ++this.size;
        return bTPosition3;
    }

    public Position<E> insertRight(Position<E> position, E e) throws InvalidPositionException {
        BTPosition<E> bTPosition = this.checkPosition(position);
        BTPosition<E> bTPosition2 = bTPosition.getRight();
        if (bTPosition2 != null) {
            throw new InvalidPositionException("Node already has a right child");
        }
        BTPosition<E> bTPosition3 = this.createNode(e, bTPosition, null, null);
        bTPosition.setRight(bTPosition3);
        ++this.size;
        return bTPosition3;
    }

    public E remove(Position<E> position) throws InvalidPositionException {
        BTPosition<E> bTPosition = this.checkPosition(position);
        BTPosition<E> bTPosition2 = bTPosition.getLeft();
        BTPosition<E> bTPosition3 = bTPosition.getRight();
        if (bTPosition2 != null && bTPosition3 != null) {
            throw new InvalidPositionException("Cannot remove node with two children");
        }
        BTPosition<E> bTPosition4 = bTPosition2 != null ? bTPosition2 : (bTPosition3 != null ? bTPosition3 : null);
        if (bTPosition == this.root) {
            if (bTPosition4 != null) {
                bTPosition4.setParent(null);
            }
            this.root = bTPosition4;
        } else {
            BTPosition<E> bTPosition5 = bTPosition.getParent();
            if (bTPosition == bTPosition5.getLeft()) {
                bTPosition5.setLeft(bTPosition4);
            } else {
                bTPosition5.setRight(bTPosition4);
            }
            if (bTPosition4 != null) {
                bTPosition4.setParent(bTPosition5);
            }
        }
        --this.size;
        return position.element();
    }

    public void attach(Position<E> position, BinaryTree<E> binaryTree, BinaryTree<E> binaryTree2) throws InvalidPositionException {
        BTPosition bTPosition;
        BTPosition bTPosition2 = this.checkPosition(position);
        if (this.isInternal(position)) {
            throw new InvalidPositionException("Cannot attach from internal node");
        }
        int n = this.size + binaryTree.size() + binaryTree2.size();
        if (!binaryTree.isEmpty()) {
            bTPosition = this.checkPosition(binaryTree.root());
            bTPosition2.setLeft(bTPosition);
            bTPosition.setParent(bTPosition2);
        }
        if (!binaryTree2.isEmpty()) {
            bTPosition = this.checkPosition(binaryTree2.root());
            bTPosition2.setRight(bTPosition);
            bTPosition.setParent(bTPosition2);
        }
        this.size = n;
    }

    public void swapElements(Position<E> position, Position<E> position2) throws InvalidPositionException {
        BTPosition<E> bTPosition = this.checkPosition(position);
        BTPosition<E> bTPosition2 = this.checkPosition(position2);
        E e = position2.element();
        bTPosition2.setElement(position.element());
        bTPosition.setElement(e);
    }

    public void expandExternal(Position<E> position, E e, E e2) throws InvalidPositionException {
        if (!this.isExternal(position)) {
            throw new InvalidPositionException("Node is not external");
        }
        this.insertLeft(position, e);
        this.insertRight(position, e2);
    }

    public void removeAboveExternal(Position<E> position) throws InvalidPositionException {
        if (!this.isExternal(position)) {
            throw new InvalidPositionException("Node is not external");
        }
        if (this.isRoot(position)) {
            this.remove(position);
        } else {
            Position<E> position2 = this.parent(position);
            this.remove(position);
            this.remove(position2);
        }
    }

    protected BTPosition<E> checkPosition(Position<E> position) throws InvalidPositionException {
        if (position == null || !(position instanceof BTPosition)) {
            throw new InvalidPositionException("The position is invalid");
        }
        return (BTPosition)position;
    }

    protected BTPosition<E> createNode(E e, BTPosition<E> bTPosition, BTPosition<E> bTPosition2, BTPosition<E> bTPosition3) {
        return new BTNode<E>(e, bTPosition, bTPosition2, bTPosition3);
    }

    protected void preorderPositions(Position<E> position, PositionList<Position<E>> positionList) throws InvalidPositionException {
        positionList.addLast(position);
        if (this.hasLeft(position)) {
            this.preorderPositions(this.left(position), positionList);
        }
        if (this.hasRight(position)) {
            this.preorderPositions(this.right(position), positionList);
        }
    }

    protected void inorderPositions(Position<E> position, PositionList<Position<E>> positionList) throws InvalidPositionException {
        if (this.hasLeft(position)) {
            this.inorderPositions(this.left(position), positionList);
        }
        positionList.addLast(position);
        if (this.hasRight(position)) {
            this.inorderPositions(this.right(position), positionList);
        }
    }
}

