/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.util.Comparator;
import net.datastructures.ArrayListCompleteBinaryTree;
import net.datastructures.CompleteBinaryTree;
import net.datastructures.DefaultComparator;
import net.datastructures.EmptyPriorityQueueException;
import net.datastructures.Entry;
import net.datastructures.InvalidKeyException;
import net.datastructures.Position;
import net.datastructures.PriorityQueue;

public class HeapPriorityQueue<K, V>
implements PriorityQueue<K, V> {
    protected CompleteBinaryTree<Entry<K, V>> heap = new ArrayListCompleteBinaryTree<Entry<K, V>>();
    protected Comparator<K> comp;

    public HeapPriorityQueue() {
        this.comp = new DefaultComparator<K>();
    }

    public HeapPriorityQueue(Comparator<K> comparator) {
        this.comp = comparator;
    }

    public void setComparator(Comparator<K> comparator) throws IllegalStateException {
        if (!this.isEmpty()) {
            throw new IllegalStateException("Priority queue is not empty");
        }
        this.comp = comparator;
    }

    @Override
    public int size() {
        return this.heap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.heap.size() == 0;
    }

    @Override
    public Entry<K, V> min() throws EmptyPriorityQueueException {
        if (this.isEmpty()) {
            throw new EmptyPriorityQueueException("Priority queue is empty");
        }
        return (Entry)this.heap.root().element();
    }

    @Override
    public Entry<K, V> insert(K k, V v) throws InvalidKeyException {
        this.checkKey(k);
        MyEntry<K, V> myEntry = new MyEntry<K, V>(k, v);
        this.upHeap(this.heap.add(myEntry));
        return myEntry;
    }

    @Override
    public Entry<K, V> removeMin() throws EmptyPriorityQueueException {
        if (this.isEmpty()) {
            throw new EmptyPriorityQueueException("Priority queue is empty");
        }
        Entry entry = (Entry)this.heap.root().element();
        if (this.size() == 1) {
            this.heap.remove();
        } else {
            this.heap.replace(this.heap.root(), this.heap.remove());
            this.downHeap(this.heap.root());
        }
        return entry;
    }

    protected void checkKey(K k) throws InvalidKeyException {
        try {
            this.comp.compare(k, k);
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Invalid key");
        }
    }

    protected void upHeap(Position<Entry<K, V>> position) {
        Position<Entry<K, V>> position2;
        while (!this.heap.isRoot(position) && this.comp.compare((position2 = this.heap.parent(position)).element().getKey(), position.element().getKey()) > 0) {
            this.swap(position2, position);
            position = position2;
        }
    }

    protected void downHeap(Position<Entry<K, V>> position) {
        Position<Entry<K, V>> position2;
        while (this.heap.isInternal(position) && this.comp.compare((position2 = !this.heap.hasRight(position) ? this.heap.left(position) : (this.comp.compare(this.heap.left(position).element().getKey(), this.heap.right(position).element().getKey()) <= 0 ? this.heap.left(position) : this.heap.right(position))).element().getKey(), position.element().getKey()) < 0) {
            this.swap(position, position2);
            position = position2;
        }
    }

    protected void swap(Position<Entry<K, V>> position, Position<Entry<K, V>> position2) {
        Entry<K, V> entry = position.element();
        this.heap.replace(position, position2.element());
        this.heap.replace(position2, entry);
    }

    public String toString() {
        return this.heap.toString();
    }

    protected static class MyEntry<K, V>
    implements Entry<K, V> {
        protected K key;
        protected V value;

        public MyEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public String toString() {
            return "(" + this.key + "," + this.value + ")";
        }
    }
}

