/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.util.Comparator;
import net.datastructures.AdaptablePriorityQueue;
import net.datastructures.Entry;
import net.datastructures.HeapPriorityQueue;
import net.datastructures.InvalidEntryException;
import net.datastructures.InvalidKeyException;
import net.datastructures.Position;

public class HeapAdaptablePriorityQueue<K, V>
extends HeapPriorityQueue<K, V>
implements AdaptablePriorityQueue<K, V> {
    public HeapAdaptablePriorityQueue() {
    }

    public HeapAdaptablePriorityQueue(Comparator comparator) {
        super(comparator);
    }

    @Override
    public Entry<K, V> insert(K k, V v) throws InvalidKeyException {
        this.checkKey(k);
        LocationAwareEntry<K, V> locationAwareEntry = new LocationAwareEntry<K, V>(k, v);
        Position position = this.heap.add(locationAwareEntry);
        locationAwareEntry.setLocation(position);
        this.upHeap(position);
        return locationAwareEntry;
    }

    @Override
    public Entry<K, V> remove(Entry<K, V> entry) throws InvalidEntryException {
        LocationAwareEntry<K, V> locationAwareEntry = this.checkEntry(entry);
        Position position = locationAwareEntry.location();
        if (this.size() == 1) {
            return (Entry)this.heap.remove();
        }
        this.replaceEntry(position, (LocationAwareEntry)this.heap.remove());
        this.upHeap(position);
        this.downHeap(position);
        locationAwareEntry.setLocation(null);
        return locationAwareEntry;
    }

    @Override
    public K replaceKey(Entry<K, V> entry, K k) throws InvalidEntryException {
        this.checkKey(k);
        LocationAwareEntry<K, V> locationAwareEntry = this.checkEntry(entry);
        K k2 = locationAwareEntry.setKey(k);
        this.upHeap(locationAwareEntry.location());
        this.downHeap(locationAwareEntry.location());
        return k2;
    }

    @Override
    public V replaceValue(Entry<K, V> entry, V v) throws InvalidEntryException {
        LocationAwareEntry<K, V> locationAwareEntry = this.checkEntry(entry);
        return locationAwareEntry.setValue(v);
    }

    @Override
    protected void swap(Position<Entry<K, V>> position, Position<Entry<K, V>> position2) {
        super.swap(position, position2);
        this.getEntry(position).setLocation(position);
        this.getEntry(position2).setLocation(position2);
    }

    protected Position replaceEntry(Position position, LocationAwareEntry<K, V> locationAwareEntry) {
        this.heap.replace(position, locationAwareEntry);
        return locationAwareEntry.setLocation(position);
    }

    protected LocationAwareEntry<K, V> getEntry(Position position) {
        return (LocationAwareEntry)position.element();
    }

    protected LocationAwareEntry<K, V> checkEntry(Entry<K, V> entry) throws InvalidEntryException {
        if (entry == null || !(entry instanceof LocationAwareEntry)) {
            throw new InvalidEntryException("Invalid entry");
        }
        return (LocationAwareEntry)entry;
    }

    protected static class LocationAwareEntry<K, V>
    extends HeapPriorityQueue.MyEntry<K, V>
    implements Entry<K, V> {
        protected Position loc;

        public LocationAwareEntry(K k, V v) {
            super(k, v);
        }

        public LocationAwareEntry(K k, V v, Position position) {
            super(k, v);
            this.loc = position;
        }

        protected Position location() {
            return this.loc;
        }

        protected Position setLocation(Position position) {
            Position position2 = this.location();
            this.loc = position;
            return position2;
        }

        protected K setKey(K k) {
            Object k2 = this.getKey();
            this.key = k;
            return k2;
        }

        protected V setValue(V v) {
            Object v2 = this.getValue();
            this.value = v;
            return v2;
        }
    }
}

