/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.util.Random;
import net.datastructures.Entry;
import net.datastructures.InvalidKeyException;
import net.datastructures.Map;
import net.datastructures.NodePositionList;

public class HashTableMap<K, V>
implements Map<K, V> {
    protected Entry<K, V> AVAILABLE = new HashEntry<Object, Object>(null, null);
    protected int n = 0;
    protected int prime;
    protected int capacity;
    protected Entry<K, V>[] bucket;
    protected long scale;
    protected long shift;

    public HashTableMap() {
        this(109345121, 1000);
    }

    public HashTableMap(int n) {
        this(109345121, n);
    }

    public HashTableMap(int n, int n2) {
        this.prime = n;
        this.capacity = n2;
        this.bucket = new Entry[this.capacity];
        Random random = new Random();
        this.scale = random.nextInt(this.prime - 1) + 1;
        this.shift = random.nextInt(this.prime);
    }

    protected void checkKey(K k) {
        if (k == null) {
            throw new InvalidKeyException("Invalid key: null.");
        }
    }

    public int hashValue(K k) {
        return (int)(Math.abs((long)k.hashCode() * this.scale + this.shift) % (long)this.prime % (long)this.capacity);
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public Iterable<K> keySet() {
        NodePositionList<K> nodePositionList = new NodePositionList<K>();
        for (int i = 0; i < this.capacity; ++i) {
            if (this.bucket[i] == null || this.bucket[i] == this.AVAILABLE) continue;
            nodePositionList.addLast(this.bucket[i].getKey());
        }
        return nodePositionList;
    }

    protected int findEntry(K k) throws InvalidKeyException {
        int n;
        int n2 = -1;
        this.checkKey(k);
        int n3 = n = this.hashValue(k);
        do {
            Entry<K, V> entry;
            if ((entry = this.bucket[n]) == null) {
                if (n2 >= 0) break;
                n2 = n;
                break;
            }
            if (k.equals(entry.getKey())) {
                return n;
            }
            if (entry != this.AVAILABLE || n2 >= 0) continue;
            n2 = n;
        } while ((n = (n + 1) % this.capacity) != n3);
        return -(n2 + 1);
    }

    @Override
    public V get(K k) throws InvalidKeyException {
        int n = this.findEntry(k);
        if (n < 0) {
            return null;
        }
        return this.bucket[n].getValue();
    }

    @Override
    public V put(K k, V v) throws InvalidKeyException {
        int n = this.findEntry(k);
        if (n >= 0) {
            return ((HashEntry)this.bucket[n]).setValue(v);
        }
        if (this.n >= this.capacity / 2) {
            this.rehash();
            n = this.findEntry(k);
        }
        this.bucket[-n - 1] = new HashEntry<K, V>(k, v);
        ++this.n;
        return null;
    }

    protected void rehash() {
        this.capacity = 2 * this.capacity;
        Entry<K, V>[] entryArray = this.bucket;
        this.bucket = new Entry[this.capacity];
        Random random = new Random();
        this.scale = random.nextInt(this.prime - 1) + 1;
        this.shift = random.nextInt(this.prime);
        for (int i = 0; i < entryArray.length; ++i) {
            Entry<K, V> entry = entryArray[i];
            if (entry == null || entry == this.AVAILABLE) continue;
            int n = -1 - this.findEntry(entry.getKey());
            this.bucket[n] = entry;
        }
    }

    @Override
    public V remove(K k) throws InvalidKeyException {
        int n = this.findEntry(k);
        if (n < 0) {
            return null;
        }
        V v = this.bucket[n].getValue();
        this.bucket[n] = this.AVAILABLE;
        --this.n;
        return v;
    }

    @Override
    public Iterable<Entry<K, V>> entrySet() {
        NodePositionList<Entry<K, V>> nodePositionList = new NodePositionList<Entry<K, V>>();
        for (int i = 0; i < this.capacity; ++i) {
            if (this.bucket[i] == null || this.bucket[i] == this.AVAILABLE) continue;
            nodePositionList.addLast(this.bucket[i]);
        }
        return nodePositionList;
    }

    @Override
    public Iterable<V> values() {
        NodePositionList<V> nodePositionList = new NodePositionList<V>();
        for (int i = 0; i < this.capacity; ++i) {
            if (this.bucket[i] == null || this.bucket[i] == this.AVAILABLE) continue;
            nodePositionList.addLast(this.bucket[i].getValue());
        }
        return nodePositionList;
    }

    public static class HashEntry<K, V>
    implements Entry<K, V> {
        protected K key;
        protected V value;

        public HashEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        public boolean equals(Object object) {
            HashEntry hashEntry;
            try {
                hashEntry = (HashEntry)object;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            return hashEntry.getKey() == this.key && hashEntry.getValue() == this.value;
        }

        public String toString() {
            return "(" + this.key + "," + this.value + ")";
        }
    }
}

