/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import net.datastructures.Edge;
import net.datastructures.InvalidPositionException;
import net.datastructures.Vertex;

public interface Graph<V, E> {
    public int numVertices();

    public int numEdges();

    public Iterable<Vertex<V>> vertices();

    public Iterable<Edge<E>> edges();

    public V replace(Vertex<V> var1, V var2) throws InvalidPositionException;

    public E replace(Edge<E> var1, E var2) throws InvalidPositionException;

    public Iterable<Edge<E>> incidentEdges(Vertex<V> var1) throws InvalidPositionException;

    public Vertex[] endVertices(Edge<E> var1) throws InvalidPositionException;

    public Vertex<V> opposite(Vertex<V> var1, Edge<E> var2) throws InvalidPositionException;

    public boolean areAdjacent(Vertex<V> var1, Vertex<V> var2) throws InvalidPositionException;

    public Vertex<V> insertVertex(V var1);

    public Edge<E> insertEdge(Vertex<V> var1, Vertex<V> var2, E var3) throws InvalidPositionException;

    public V removeVertex(Vertex<V> var1) throws InvalidPositionException;

    public E removeEdge(Edge<E> var1) throws InvalidPositionException;
}

