/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import net.datastructures.DFS;
import net.datastructures.Edge;
import net.datastructures.NodePositionList;
import net.datastructures.Position;
import net.datastructures.PositionList;
import net.datastructures.Vertex;

public class FindPathDFS<V, E>
extends DFS<V, E, Vertex<V>, Iterable<Position>> {
    protected PositionList<Position> path;
    protected boolean done;

    @Override
    public void setup() {
        this.path = new NodePositionList<Position>();
        this.done = false;
    }

    @Override
    protected void startVisit(Vertex<V> vertex) {
        this.path.addLast(vertex);
        if (vertex == this.info) {
            this.done = true;
        }
    }

    @Override
    protected void finishVisit(Vertex<V> vertex) {
        this.path.remove(this.path.last());
        if (!this.path.isEmpty()) {
            this.path.remove(this.path.last());
        }
    }

    @Override
    protected void traverseDiscovery(Edge<E> edge, Vertex<V> vertex) {
        this.path.addLast(edge);
    }

    @Override
    protected boolean isDone() {
        return this.done;
    }

    @Override
    public Iterable<Position> finalResult(Iterable<Position> iterable) {
        return this.path;
    }
}

