/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import net.datastructures.DFS;
import net.datastructures.Edge;
import net.datastructures.NodePositionList;
import net.datastructures.Position;
import net.datastructures.PositionList;
import net.datastructures.Vertex;

public class FindCycleDFS<V, E>
extends DFS<V, E, Object, Iterable<Position>> {
    protected PositionList<Position> cycle;
    protected boolean done;
    protected Vertex<V> cycleStart;

    @Override
    public void setup() {
        this.cycle = new NodePositionList<Position>();
        this.done = false;
    }

    @Override
    protected void startVisit(Vertex<V> vertex) {
        this.cycle.addLast(vertex);
    }

    @Override
    protected void finishVisit(Vertex<V> vertex) {
        this.cycle.remove(this.cycle.last());
        if (!this.cycle.isEmpty()) {
            this.cycle.remove(this.cycle.last());
        }
    }

    @Override
    protected void traverseDiscovery(Edge<E> edge, Vertex<V> vertex) {
        this.cycle.addLast(edge);
    }

    @Override
    protected void traverseBack(Edge<E> edge, Vertex<V> vertex) {
        this.cycle.addLast(edge);
        this.cycleStart = this.graph.opposite(vertex, edge);
        this.cycle.addLast(this.cycleStart);
        this.done = true;
    }

    @Override
    protected boolean isDone() {
        return this.done;
    }

    @Override
    public Iterable<Position> finalResult(Iterable<Position> iterable) {
        if (!this.cycle.isEmpty()) {
            for (Position<Position> position : this.cycle.positions()) {
                if (position.element() == this.cycleStart) break;
                this.cycle.remove(position);
            }
        }
        return this.cycle;
    }
}

