/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import net.datastructures.BinaryTree;
import net.datastructures.Position;

public abstract class EulerTour<E, R> {
    protected BinaryTree<E> tree;

    public abstract R execute(BinaryTree<E> var1);

    protected void init(BinaryTree<E> binaryTree) {
        this.tree = binaryTree;
    }

    protected R eulerTour(Position<E> position) {
        TourResult tourResult = new TourResult();
        this.visitLeft(position, tourResult);
        if (this.tree.hasLeft(position)) {
            tourResult.left = this.eulerTour(this.tree.left(position));
        }
        this.visitBelow(position, tourResult);
        if (this.tree.hasRight(position)) {
            tourResult.right = this.eulerTour(this.tree.right(position));
        }
        this.visitRight(position, tourResult);
        return tourResult.out;
    }

    protected void visitLeft(Position<E> position, TourResult<R> tourResult) {
    }

    protected void visitBelow(Position<E> position, TourResult<R> tourResult) {
    }

    protected void visitRight(Position<E> position, TourResult<R> tourResult) {
    }

    public class TourResult<R> {
        public R left;
        public R right;
        public R out;
    }
}

