/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.util.Comparator;
import net.datastructures.AdaptablePriorityQueue;
import net.datastructures.DefaultComparator;
import net.datastructures.Edge;
import net.datastructures.Entry;
import net.datastructures.Graph;
import net.datastructures.HeapAdaptablePriorityQueue;
import net.datastructures.Vertex;

public class Dijkstra<V, E> {
    protected static final Integer INFINITE = Integer.MAX_VALUE;
    protected Graph<V, E> graph;
    protected Object WEIGHT;
    protected Object DIST = new Object();
    protected Object ENTRY = new Object();
    protected AdaptablePriorityQueue<Integer, Vertex<V>> Q;

    public void execute(Graph<V, E> graph, Vertex<V> vertex, Object object) {
        this.graph = graph;
        this.WEIGHT = object;
        DefaultComparator defaultComparator = new DefaultComparator();
        this.Q = new HeapAdaptablePriorityQueue<Integer, Vertex<V>>((Comparator)defaultComparator);
        this.dijkstraVisit(vertex);
    }

    public int getDist(Vertex<V> vertex) {
        return (Integer)vertex.get(this.DIST);
    }

    protected void dijkstraVisit(Vertex<V> vertex) {
        int n;
        for (Vertex<Entry<Integer, Vertex<V>>> vertex2 : this.graph.vertices()) {
            n = vertex2 == vertex ? 0 : INFINITE;
            Entry<Integer, Vertex<V>> entry = this.Q.insert(n, vertex2);
            vertex2.put(this.ENTRY, entry);
        }
        while (!this.Q.isEmpty()) {
            Entry entry = this.Q.min();
            Vertex vertex2 = (Vertex)entry.getValue();
            n = (Integer)entry.getKey();
            this.Q.remove(entry);
            vertex2.put(this.DIST, n);
            vertex2.remove(this.ENTRY);
            if (n == INFINITE) continue;
            for (Edge edge : this.graph.incidentEdges(vertex2)) {
                int n2;
                int n3;
                Vertex<V> vertex3 = this.graph.opposite(vertex2, edge);
                Entry entry2 = (Entry)vertex3.get(this.ENTRY);
                if (entry2 == null || n + (n3 = ((Integer)edge.get(this.WEIGHT)).intValue()) >= (n2 = ((Integer)entry2.getKey()).intValue())) continue;
                this.Q.replaceKey(entry2, n + n3);
            }
        }
    }
}

