/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import net.datastructures.DecorablePosition;
import net.datastructures.Edge;
import net.datastructures.Graph;
import net.datastructures.Vertex;

public class DFS<V, E, I, R> {
    protected Graph<V, E> graph;
    protected Vertex<V> start;
    protected I info;
    protected R visitResult;
    protected static Object STATUS = new Object();
    protected static Object VISITED = new Object();
    protected static Object UNVISITED = new Object();

    public R execute(Graph<V, E> graph, Vertex<V> vertex, I i) {
        this.graph = graph;
        this.start = vertex;
        this.info = i;
        for (Vertex<V> decorablePosition : this.graph.vertices()) {
            this.unVisit(decorablePosition);
        }
        for (Edge edge : this.graph.edges()) {
            this.unVisit(edge);
        }
        this.setup();
        return this.finalResult(this.dfsTraversal(this.start));
    }

    protected R dfsTraversal(Vertex<V> vertex) {
        this.initResult();
        if (!this.isDone()) {
            this.startVisit(vertex);
        }
        if (!this.isDone()) {
            this.visit(vertex);
            for (Edge<E> edge : this.graph.incidentEdges(vertex)) {
                if (this.isVisited(edge)) continue;
                this.visit(edge);
                Vertex<V> vertex2 = this.graph.opposite(vertex, edge);
                if (!this.isVisited(vertex2)) {
                    this.traverseDiscovery(edge, vertex);
                    if (this.isDone()) break;
                    this.visitResult = this.dfsTraversal(vertex2);
                    if (!this.isDone()) continue;
                    break;
                }
                this.traverseBack(edge, vertex);
                if (!this.isDone()) continue;
                break;
            }
        }
        if (!this.isDone()) {
            this.finishVisit(vertex);
        }
        return this.result();
    }

    protected void visit(DecorablePosition<?> decorablePosition) {
        decorablePosition.put(STATUS, VISITED);
    }

    protected void unVisit(DecorablePosition<?> decorablePosition) {
        decorablePosition.put(STATUS, UNVISITED);
    }

    protected boolean isVisited(DecorablePosition<?> decorablePosition) {
        return decorablePosition.get(STATUS) == VISITED;
    }

    protected void setup() {
    }

    protected void initResult() {
    }

    protected void startVisit(Vertex<V> vertex) {
    }

    protected void finishVisit(Vertex<V> vertex) {
    }

    protected void traverseDiscovery(Edge<E> edge, Vertex<V> vertex) {
    }

    protected void traverseBack(Edge<E> edge, Vertex<V> vertex) {
    }

    protected boolean isDone() {
        return false;
    }

    protected R result() {
        return null;
    }

    protected R finalResult(R r) {
        return r;
    }
}

