/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.util.Comparator;
import net.datastructures.BTPosition;
import net.datastructures.DefaultComparator;
import net.datastructures.Dictionary;
import net.datastructures.Entry;
import net.datastructures.InvalidEntryException;
import net.datastructures.InvalidKeyException;
import net.datastructures.LinkedBinaryTree;
import net.datastructures.NodePositionList;
import net.datastructures.Position;
import net.datastructures.PositionList;

public class BinarySearchTree<K, V>
extends LinkedBinaryTree<Entry<K, V>>
implements Dictionary<K, V> {
    protected Comparator<K> C;
    protected Position<Entry<K, V>> actionPos;
    protected int numEntries = 0;

    public BinarySearchTree() {
        this.C = new DefaultComparator<K>();
        this.addRoot(null);
    }

    public BinarySearchTree(Comparator<K> comparator) {
        this.C = comparator;
        this.addRoot(null);
    }

    protected K key(Position<Entry<K, V>> position) {
        return position.element().getKey();
    }

    protected V value(Position<Entry<K, V>> position) {
        return position.element().getValue();
    }

    protected Entry<K, V> entry(Position<Entry<K, V>> position) {
        return position.element();
    }

    protected void replaceEntry(Position<Entry<K, V>> position, Entry<K, V> entry) {
        ((BSTEntry)entry).pos = position;
        this.replace(position, entry);
    }

    protected void checkKey(K k) throws InvalidKeyException {
        if (k == null) {
            throw new InvalidKeyException("null key");
        }
    }

    protected void checkEntry(Entry<K, V> entry) throws InvalidEntryException {
        if (entry == null || !(entry instanceof BSTEntry)) {
            throw new InvalidEntryException("invalid entry");
        }
    }

    protected Entry<K, V> insertAtExternal(Position<Entry<K, V>> position, Entry<K, V> entry) {
        this.expandExternal(position, null, null);
        this.replace(position, entry);
        ++this.numEntries;
        return entry;
    }

    protected void removeExternal(Position<Entry<K, V>> position) {
        this.removeAboveExternal(position);
        --this.numEntries;
    }

    protected Position<Entry<K, V>> treeSearch(K k, Position<Entry<K, V>> position) {
        if (this.isExternal(position)) {
            return position;
        }
        K k2 = this.key(position);
        int n = this.C.compare(k, k2);
        if (n < 0) {
            return this.treeSearch(k, this.left(position));
        }
        if (n > 0) {
            return this.treeSearch(k, this.right(position));
        }
        return position;
    }

    protected void addAll(PositionList<Entry<K, V>> positionList, Position<Entry<K, V>> position, K k) {
        if (this.isExternal(position)) {
            return;
        }
        Position<Entry<K, V>> position2 = this.treeSearch(k, position);
        if (!this.isExternal(position2)) {
            this.addAll(positionList, this.left(position2), k);
            positionList.addLast(position2.element());
            this.addAll(positionList, this.right(position2), k);
        }
    }

    @Override
    public int size() {
        return this.numEntries;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Entry<K, V> find(K k) throws InvalidKeyException {
        this.checkKey(k);
        Position<Entry<K, V>> position = this.treeSearch(k, this.root());
        this.actionPos = position;
        if (this.isInternal(position)) {
            return this.entry(position);
        }
        return null;
    }

    @Override
    public Iterable<Entry<K, V>> findAll(K k) throws InvalidKeyException {
        this.checkKey(k);
        NodePositionList<Entry<K, V>> nodePositionList = new NodePositionList<Entry<K, V>>();
        this.addAll(nodePositionList, this.root(), k);
        return nodePositionList;
    }

    @Override
    public Entry<K, V> insert(K k, V v) throws InvalidKeyException {
        this.checkKey(k);
        Position<Entry<K, V>> position = this.treeSearch(k, this.root());
        while (!this.isExternal(position)) {
            position = this.treeSearch(k, this.left(position));
        }
        this.actionPos = position;
        return this.insertAtExternal(position, new BSTEntry<K, V>(k, v, position));
    }

    @Override
    public Entry<K, V> remove(Entry<K, V> entry) throws InvalidEntryException {
        this.checkEntry(entry);
        Position position = ((BSTEntry)entry).position();
        Entry entry2 = this.entry(position);
        if (this.isExternal(this.left(position))) {
            position = this.left(position);
        } else if (this.isExternal(this.right(position))) {
            position = this.right(position);
        } else {
            Position position2 = position;
            position = this.right(position2);
            while (this.isInternal(position = this.left(position))) {
            }
            this.replaceEntry(position2, this.parent(position).element());
        }
        this.actionPos = this.sibling(position);
        this.removeExternal(position);
        return entry2;
    }

    @Override
    public Iterable<Entry<K, V>> entries() {
        NodePositionList<Entry<K, V>> nodePositionList = new NodePositionList<Entry<K, V>>();
        Iterable iterable = this.positions();
        for (Position position : iterable) {
            if (!this.isInternal(position)) continue;
            nodePositionList.addLast((Entry<K, V>)position.element());
        }
        return nodePositionList;
    }

    protected Position<Entry<K, V>> restructure(Position<Entry<K, V>> position) {
        BTPosition bTPosition;
        BTPosition bTPosition2;
        BTPosition bTPosition3;
        BTPosition bTPosition4;
        BTPosition bTPosition5;
        BTPosition bTPosition6;
        BTPosition bTPosition7;
        Position<Entry<K, V>> position2 = this.parent(position);
        Position<Entry<K, V>> position3 = this.parent(position2);
        boolean bl = position == this.left(position2);
        boolean bl2 = position2 == this.left(position3);
        BTPosition bTPosition8 = (BTPosition)position;
        BTPosition bTPosition9 = (BTPosition)position2;
        BTPosition bTPosition10 = (BTPosition)position3;
        if (bl && bl2) {
            bTPosition7 = bTPosition8;
            bTPosition6 = bTPosition9;
            bTPosition5 = bTPosition10;
            bTPosition4 = bTPosition7.getLeft();
            bTPosition3 = bTPosition7.getRight();
            bTPosition2 = bTPosition6.getRight();
            bTPosition = bTPosition5.getRight();
        } else if (!bl && bl2) {
            bTPosition7 = bTPosition9;
            bTPosition6 = bTPosition8;
            bTPosition5 = bTPosition10;
            bTPosition4 = bTPosition7.getLeft();
            bTPosition3 = bTPosition6.getLeft();
            bTPosition2 = bTPosition6.getRight();
            bTPosition = bTPosition5.getRight();
        } else if (bl && !bl2) {
            bTPosition7 = bTPosition10;
            bTPosition6 = bTPosition8;
            bTPosition5 = bTPosition9;
            bTPosition4 = bTPosition7.getLeft();
            bTPosition3 = bTPosition6.getLeft();
            bTPosition2 = bTPosition6.getRight();
            bTPosition = bTPosition5.getRight();
        } else {
            bTPosition7 = bTPosition10;
            bTPosition6 = bTPosition9;
            bTPosition5 = bTPosition8;
            bTPosition4 = bTPosition7.getLeft();
            bTPosition3 = bTPosition6.getLeft();
            bTPosition2 = bTPosition5.getLeft();
            bTPosition = bTPosition5.getRight();
        }
        if (this.isRoot(position3)) {
            this.root = bTPosition6;
            bTPosition6.setParent(null);
        } else {
            BTPosition bTPosition11 = (BTPosition)this.parent(position3);
            if (position3 == this.left(bTPosition11)) {
                bTPosition6.setParent(bTPosition11);
                bTPosition11.setLeft(bTPosition6);
            } else {
                bTPosition6.setParent(bTPosition11);
                bTPosition11.setRight(bTPosition6);
            }
        }
        bTPosition6.setLeft(bTPosition7);
        bTPosition7.setParent(bTPosition6);
        bTPosition6.setRight(bTPosition5);
        bTPosition5.setParent(bTPosition6);
        bTPosition7.setLeft(bTPosition4);
        bTPosition4.setParent(bTPosition7);
        bTPosition7.setRight(bTPosition3);
        bTPosition3.setParent(bTPosition7);
        bTPosition5.setLeft(bTPosition2);
        bTPosition2.setParent(bTPosition5);
        bTPosition5.setRight(bTPosition);
        bTPosition.setParent(bTPosition5);
        ((BSTEntry)bTPosition7.element()).pos = bTPosition7;
        ((BSTEntry)bTPosition6.element()).pos = bTPosition6;
        ((BSTEntry)bTPosition5.element()).pos = bTPosition5;
        return bTPosition6;
    }

    protected static class BSTEntry<K, V>
    implements Entry<K, V> {
        protected K key;
        protected V value;
        protected Position<Entry<K, V>> pos;

        BSTEntry() {
        }

        BSTEntry(K k, V v, Position<Entry<K, V>> position) {
            this.key = k;
            this.value = v;
            this.pos = position;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public Position<Entry<K, V>> position() {
            return this.pos;
        }
    }
}

