/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import net.datastructures.EmptyStackException;
import net.datastructures.FullStackException;
import net.datastructures.Stack;

public class ArrayStack<E>
implements Stack<E> {
    protected int capacity;
    public static final int CAPACITY = 1000;
    protected E[] S;
    protected int top = -1;

    public ArrayStack() {
        this(1000);
    }

    public ArrayStack(int n) {
        this.capacity = n;
        this.S = new Object[this.capacity];
    }

    @Override
    public int size() {
        return this.top + 1;
    }

    @Override
    public boolean isEmpty() {
        return this.top < 0;
    }

    @Override
    public void push(E e) throws FullStackException {
        if (this.size() == this.capacity) {
            throw new FullStackException("Stack is full.");
        }
        this.S[++this.top] = e;
    }

    @Override
    public E top() throws EmptyStackException {
        if (this.isEmpty()) {
            throw new EmptyStackException("Stack is empty.");
        }
        return this.S[this.top];
    }

    @Override
    public E pop() throws EmptyStackException {
        if (this.isEmpty()) {
            throw new EmptyStackException("Stack is empty.");
        }
        E e = this.S[this.top];
        this.S[this.top--] = null;
        return e;
    }

    public String toString() {
        String string = "[";
        if (this.size() > 0) {
            string = string + this.S[0];
        }
        if (this.size() > 1) {
            for (int i = 1; i <= this.size() - 1; ++i) {
                string = string + ", " + this.S[i];
            }
        }
        return string + "]";
    }

    public void status(String string, Object object) {
        System.out.print("------> " + string);
        System.out.println(", returns " + object);
        System.out.print("result: size = " + this.size() + ", isEmpty = " + this.isEmpty());
        System.out.println(", stack: " + this);
    }

    public static void main(String[] stringArray) {
        ArrayStack<Integer> arrayStack = new ArrayStack<Integer>();
        arrayStack.status("new ArrayStack<Integer> A", null);
        arrayStack.push(7);
        arrayStack.status("A.push(7)", null);
        Object e = arrayStack.pop();
        arrayStack.status("A.pop()", e);
        arrayStack.push(9);
        arrayStack.status("A.push(9)", null);
        e = arrayStack.pop();
        arrayStack.status("A.pop()", e);
        ArrayStack<String> arrayStack2 = new ArrayStack<String>();
        arrayStack2.status("new ArrayStack<String> B", null);
        arrayStack2.push("Bob");
        arrayStack2.status("B.push(\"Bob\")", null);
        arrayStack2.push("Alice");
        arrayStack2.status("B.push(\"Alice\")", null);
        e = arrayStack2.pop();
        arrayStack2.status("B.pop()", e);
        arrayStack2.push("Eve");
        arrayStack2.status("B.push(\"Eve\")", null);
    }
}

