/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.util.ArrayList;
import java.util.Iterator;
import net.datastructures.BoundaryViolationException;
import net.datastructures.CompleteBinaryTree;
import net.datastructures.EmptyTreeException;
import net.datastructures.InvalidPositionException;
import net.datastructures.NodePositionList;
import net.datastructures.Position;

public class ArrayListCompleteBinaryTree<E>
implements CompleteBinaryTree<E> {
    protected ArrayList<BTPos<E>> T = new ArrayList();

    public ArrayListCompleteBinaryTree() {
        this.T.add(0, null);
    }

    @Override
    public int size() {
        return this.T.size() - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isInternal(Position<E> position) throws InvalidPositionException {
        return this.hasLeft(position);
    }

    @Override
    public boolean isExternal(Position<E> position) throws InvalidPositionException {
        return !this.isInternal(position);
    }

    @Override
    public boolean isRoot(Position<E> position) throws InvalidPositionException {
        BTPos<E> bTPos = this.checkPosition(position);
        return bTPos.index() == 1;
    }

    @Override
    public boolean hasLeft(Position<E> position) throws InvalidPositionException {
        BTPos<E> bTPos = this.checkPosition(position);
        return 2 * bTPos.index() <= this.size();
    }

    @Override
    public boolean hasRight(Position<E> position) throws InvalidPositionException {
        BTPos<E> bTPos = this.checkPosition(position);
        return 2 * bTPos.index() + 1 <= this.size();
    }

    @Override
    public Position<E> root() throws EmptyTreeException {
        if (this.isEmpty()) {
            throw new EmptyTreeException("Tree is empty");
        }
        return this.T.get(1);
    }

    @Override
    public Position<E> left(Position<E> position) throws InvalidPositionException, BoundaryViolationException {
        if (!this.hasLeft(position)) {
            throw new BoundaryViolationException("No left child");
        }
        BTPos<E> bTPos = this.checkPosition(position);
        return this.T.get(2 * bTPos.index());
    }

    @Override
    public Position<E> right(Position<E> position) throws InvalidPositionException {
        if (!this.hasRight(position)) {
            throw new BoundaryViolationException("No right child");
        }
        BTPos<E> bTPos = this.checkPosition(position);
        return this.T.get(2 * bTPos.index() + 1);
    }

    @Override
    public Position<E> parent(Position<E> position) throws InvalidPositionException, BoundaryViolationException {
        if (this.isRoot(position)) {
            throw new BoundaryViolationException("No parent");
        }
        BTPos<E> bTPos = this.checkPosition(position);
        return this.T.get(bTPos.index() / 2);
    }

    @Override
    public Iterable<Position<E>> children(Position<E> position) throws InvalidPositionException {
        NodePositionList<Position<Position<E>>> nodePositionList = new NodePositionList<Position<Position<E>>>();
        if (this.hasLeft(position)) {
            nodePositionList.addLast(this.left(position));
        }
        if (this.hasRight(position)) {
            nodePositionList.addLast(this.right(position));
        }
        return nodePositionList;
    }

    @Override
    public Iterable<Position<E>> positions() {
        ArrayList<Position<BTPos<E>>> arrayList = new ArrayList<Position<BTPos<E>>>();
        Iterator<BTPos<E>> iterator = this.T.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public E replace(Position<E> position, E e) throws InvalidPositionException {
        BTPos<E> bTPos = this.checkPosition(position);
        return bTPos.setElement(e);
    }

    @Override
    public Position<E> add(E e) {
        int n = this.size() + 1;
        BTPos<E> bTPos = new BTPos<E>(e, n);
        this.T.add(n, bTPos);
        return bTPos;
    }

    @Override
    public E remove() throws EmptyTreeException {
        if (this.isEmpty()) {
            throw new EmptyTreeException("Tree is empty");
        }
        return this.T.remove(this.size()).element();
    }

    protected BTPos<E> checkPosition(Position<E> position) throws InvalidPositionException {
        if (position == null || !(position instanceof BTPos)) {
            throw new InvalidPositionException("Position is invalid");
        }
        return (BTPos)position;
    }

    public Position<E> sibling(Position<E> position) throws InvalidPositionException, BoundaryViolationException {
        try {
            Position<E> position2 = this.parent(position);
            Position<E> position3 = this.left(position2);
            if (position == position3) {
                return this.right(position2);
            }
            return position3;
        }
        catch (BoundaryViolationException boundaryViolationException) {
            throw new BoundaryViolationException("Node has no sibling");
        }
    }

    public void swapElements(Position<E> position, Position<E> position2) throws InvalidPositionException {
        BTPos<E> bTPos = this.checkPosition(position);
        BTPos<E> bTPos2 = this.checkPosition(position2);
        E e = bTPos.element();
        bTPos.setElement(bTPos2.element());
        bTPos2.setElement(e);
    }

    @Override
    public Iterator<E> iterator() {
        ArrayList<E> arrayList = new ArrayList<E>();
        Iterator<BTPos<E>> iterator = this.T.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().element());
        }
        return arrayList.iterator();
    }

    public String toString() {
        return this.T.toString();
    }

    protected static class BTPos<E>
    implements Position<E> {
        E element;
        int index;

        public BTPos(E e, int n) {
            this.element = e;
            this.index = n;
        }

        @Override
        public E element() {
            return this.element;
        }

        public int index() {
            return this.index;
        }

        public E setElement(E e) {
            E e2 = this.element;
            this.element = e;
            return e2;
        }

        public String toString() {
            return "[" + this.element + "," + this.index + "]";
        }
    }
}

