/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import net.datastructures.IndexList;

public class ArrayIndexList<E>
implements IndexList<E> {
    private E[] A = new Object[this.capacity];
    private int capacity = 16;
    private int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public E get(int n) throws IndexOutOfBoundsException {
        this.checkIndex(n, this.size());
        return this.A[n];
    }

    @Override
    public E set(int n, E e) throws IndexOutOfBoundsException {
        this.checkIndex(n, this.size());
        E e2 = this.A[n];
        this.A[n] = e;
        return e2;
    }

    @Override
    public void add(int n, E e) throws IndexOutOfBoundsException {
        this.checkIndex(n, this.size() + 1);
        if (this.size == this.capacity) {
            this.capacity *= 2;
            Object[] objectArray = new Object[this.capacity];
            for (int i = 0; i < this.size; ++i) {
                objectArray[i] = this.A[i];
            }
            this.A = objectArray;
        }
        for (int i = this.size - 1; i >= n; --i) {
            this.A[i + 1] = this.A[i];
        }
        this.A[n] = e;
        ++this.size;
    }

    @Override
    public E remove(int n) throws IndexOutOfBoundsException {
        this.checkIndex(n, this.size());
        E e = this.A[n];
        for (int i = n; i < this.size - 1; ++i) {
            this.A[i] = this.A[i + 1];
        }
        --this.size;
        return e;
    }

    protected void checkIndex(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("Illegal index: " + n);
        }
    }
}

