/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import net.datastructures.DecorablePosition;
import net.datastructures.Edge;
import net.datastructures.Graph;
import net.datastructures.HashTableMap;
import net.datastructures.InvalidPositionException;
import net.datastructures.NodePositionList;
import net.datastructures.Position;
import net.datastructures.PositionList;
import net.datastructures.Vertex;

public class AdjacencyListGraph<V, E>
implements Graph<V, E> {
    protected NodePositionList<Vertex<V>> VList = new NodePositionList();
    protected NodePositionList<Edge<E>> EList = new NodePositionList();

    @Override
    public Iterable<Vertex<V>> vertices() {
        return this.VList;
    }

    @Override
    public Iterable<Edge<E>> edges() {
        return this.EList;
    }

    public Object replace(Position position, Object object) throws InvalidPositionException {
        MyPosition myPosition = this.checkPosition(position);
        Object e = position.element();
        myPosition.setElement(object);
        return e;
    }

    @Override
    public Iterable<Edge<E>> incidentEdges(Vertex<V> vertex) throws InvalidPositionException {
        MyVertex<V> myVertex = this.checkVertex(vertex);
        return myVertex.incidentEdges();
    }

    @Override
    public Vertex<V>[] endVertices(Edge<E> edge) throws InvalidPositionException {
        MyEdge<E> myEdge = this.checkEdge(edge);
        return myEdge.endVertices();
    }

    @Override
    public Vertex<V> opposite(Vertex<V> vertex, Edge<E> edge) throws InvalidPositionException {
        this.checkVertex(vertex);
        MyEdge<E> myEdge = this.checkEdge(edge);
        MyVertex<V>[] myVertexArray = myEdge.endVertices();
        if (vertex == myVertexArray[0]) {
            return myVertexArray[1];
        }
        if (vertex == myVertexArray[1]) {
            return myVertexArray[0];
        }
        throw new InvalidPositionException("No such vertex exists");
    }

    @Override
    public boolean areAdjacent(Vertex<V> vertex, Vertex<V> vertex2) throws InvalidPositionException {
        Iterable<Edge<E>> iterable = this.degree(vertex) < this.degree(vertex2) ? this.incidentEdges(vertex) : this.incidentEdges(vertex2);
        for (Edge<E> edge : iterable) {
            Vertex<V>[] vertexArray = this.endVertices(edge);
            if ((vertexArray[0] != vertex || vertexArray[1] != vertex2) && (vertexArray[0] != vertex2 || vertexArray[1] != vertex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Vertex<V> insertVertex(V v) {
        MyVertex<V> myVertex = new MyVertex<V>(v);
        this.VList.addLast(myVertex);
        Position<Vertex<V>> position = this.VList.last();
        myVertex.setLocation(position);
        return myVertex;
    }

    @Override
    public Edge<E> insertEdge(Vertex<V> vertex, Vertex<V> vertex2, E e) throws InvalidPositionException {
        MyVertex<V> myVertex = this.checkVertex(vertex);
        MyVertex<V> myVertex2 = this.checkVertex(vertex2);
        MyEdge<E> myEdge = new MyEdge<E>(vertex, vertex2, e);
        Position<Edge<E>> position = myVertex.insertIncidence(myEdge);
        Position<Edge<E>> position2 = myVertex2.insertIncidence(myEdge);
        myEdge.setIncidences(position, position2);
        this.EList.addLast(myEdge);
        Position<Edge<E>> position3 = this.EList.last();
        myEdge.setLocation(position3);
        return myEdge;
    }

    @Override
    public V removeVertex(Vertex<V> vertex) throws InvalidPositionException {
        MyVertex<V> myVertex = this.checkVertex(vertex);
        for (MyEdge myEdge : this.incidentEdges(vertex)) {
            if (myEdge.location() == null) continue;
            this.removeEdge(myEdge);
        }
        this.VList.remove(myVertex.location());
        return (V)vertex.element();
    }

    @Override
    public E removeEdge(Edge<E> edge) throws InvalidPositionException {
        MyEdge myEdge = this.checkEdge(edge);
        MyVertex<V>[] myVertexArray = myEdge.endVertices();
        Position<Edge<E>>[] positionArray = myEdge.incidences();
        myVertexArray[0].removeIncidence(positionArray[0]);
        myVertexArray[1].removeIncidence(positionArray[1]);
        this.EList.remove(myEdge.location());
        myEdge.setLocation(null);
        return edge.element();
    }

    public int degree(Vertex<V> vertex) {
        MyVertex<V> myVertex = this.checkVertex(vertex);
        return myVertex.degree();
    }

    protected MyPosition checkPosition(Position position) throws InvalidPositionException {
        if (position == null || !(position instanceof MyPosition)) {
            throw new InvalidPositionException("Position is invalid");
        }
        return (MyPosition)position;
    }

    protected MyVertex<V> checkVertex(Vertex<V> vertex) throws InvalidPositionException {
        if (vertex == null || !(vertex instanceof MyVertex)) {
            throw new InvalidPositionException("Vertex is invalid");
        }
        return (MyVertex)vertex;
    }

    protected MyEdge<E> checkEdge(Edge<E> edge) throws InvalidPositionException {
        if (edge == null || !(edge instanceof MyEdge)) {
            throw new InvalidPositionException("Edge is invalid");
        }
        return (MyEdge)edge;
    }

    public String toString() {
        return this.VList.toString() + "\n" + this.EList.toString();
    }

    @Override
    public int numVertices() {
        return this.VList.size();
    }

    @Override
    public int numEdges() {
        return this.EList.size();
    }

    @Override
    public V replace(Vertex<V> vertex, V v) throws InvalidPositionException {
        Object e = vertex.element();
        MyVertex<V> myVertex = this.checkVertex(vertex);
        myVertex.setElement(v);
        return (V)e;
    }

    @Override
    public E replace(Edge<E> edge, E e) throws InvalidPositionException {
        Object e2 = edge.element();
        MyEdge<E> myEdge = this.checkEdge(edge);
        myEdge.setElement(e);
        return e2;
    }

    protected class MyEdge<E>
    extends MyPosition<E>
    implements Edge<E> {
        protected MyVertex<V>[] endVertices;
        protected Position<Edge<E>>[] Inc;
        protected Position<Edge<E>> loc;

        MyEdge(Vertex<V> vertex, Vertex<V> vertex2, E e) {
            this.elem = e;
            this.endVertices = new MyVertex[2];
            this.endVertices[0] = (MyVertex)vertex;
            this.endVertices[1] = (MyVertex)vertex2;
            this.Inc = new Position[2];
        }

        public MyVertex<V>[] endVertices() {
            return this.endVertices;
        }

        public Position<Edge<E>>[] incidences() {
            return this.Inc;
        }

        public void setIncidences(Position<Edge<E>> position, Position<Edge<E>> position2) {
            this.Inc[0] = position;
            this.Inc[1] = position2;
        }

        public Position<Edge<E>> location() {
            return this.loc;
        }

        public void setLocation(Position<Edge<E>> position) {
            this.loc = position;
        }

        public String toString() {
            return this.element() + "(" + this.endVertices[0].toString() + "," + this.endVertices[1].toString() + ")";
        }
    }

    protected class MyVertex<V>
    extends MyPosition<V>
    implements Vertex<V> {
        protected PositionList<Edge<E>> incEdges;
        protected Position<Vertex<V>> loc;

        MyVertex(V v) {
            this.elem = v;
            this.incEdges = new NodePositionList();
        }

        public int degree() {
            return this.incEdges.size();
        }

        public Iterable<Edge<E>> incidentEdges() {
            return this.incEdges;
        }

        public Position<Edge<E>> insertIncidence(Edge<E> edge) {
            this.incEdges.addLast(edge);
            return this.incEdges.last();
        }

        public void removeIncidence(Position<Edge<E>> position) {
            this.incEdges.remove(position);
        }

        public Position<Vertex<V>> location() {
            return this.loc;
        }

        public void setLocation(Position<Vertex<V>> position) {
            this.loc = position;
        }

        public String toString() {
            return this.elem.toString();
        }
    }

    protected static class MyPosition<T>
    extends HashTableMap<Object, Object>
    implements DecorablePosition<T> {
        protected T elem;

        protected MyPosition() {
        }

        @Override
        public T element() {
            return this.elem;
        }

        public void setElement(T t) {
            this.elem = t;
        }
    }
}

