/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.util.Comparator;
import net.datastructures.BTNode;
import net.datastructures.BTPosition;
import net.datastructures.BinarySearchTreeMap;
import net.datastructures.Entry;
import net.datastructures.InvalidKeyException;
import net.datastructures.Map;
import net.datastructures.Position;

public class AVLTreeMap<K, V>
extends BinarySearchTreeMap<K, V>
implements Map<K, V> {
    public AVLTreeMap(Comparator<K> comparator) {
        super(comparator);
    }

    public AVLTreeMap() {
    }

    @Override
    protected BTPosition<Entry<K, V>> createNode(Entry<K, V> entry, BTPosition<Entry<K, V>> bTPosition, BTPosition<Entry<K, V>> bTPosition2, BTPosition<Entry<K, V>> bTPosition3) {
        return new AVLNode<K, V>(entry, bTPosition, bTPosition2, bTPosition3);
    }

    protected int height(Position<Entry<K, V>> position) {
        return ((AVLNode)position).getHeight();
    }

    protected void setHeight(Position<Entry<K, V>> position) {
        ((AVLNode)position).setHeight(1 + Math.max(this.height(this.left(position)), this.height(this.right(position))));
    }

    protected boolean isBalanced(Position<Entry<K, V>> position) {
        int n = this.height(this.left(position)) - this.height(this.right(position));
        return -1 <= n && n <= 1;
    }

    protected Position<Entry<K, V>> tallerChild(Position<Entry<K, V>> position) {
        if (this.height(this.left(position)) > this.height(this.right(position))) {
            return this.left(position);
        }
        if (this.height(this.left(position)) < this.height(this.right(position))) {
            return this.right(position);
        }
        if (this.isRoot(position)) {
            return this.left(position);
        }
        if (position == this.left(this.parent(position))) {
            return this.left(position);
        }
        return this.right(position);
    }

    protected void rebalance(Position<Entry<K, V>> position) {
        if (this.isInternal(position)) {
            this.setHeight(position);
        }
        while (!this.isRoot(position)) {
            position = this.parent(position);
            this.setHeight(position);
            if (this.isBalanced(position)) continue;
            Position<Entry<K, V>> position2 = this.tallerChild(this.tallerChild(position));
            position = this.restructure(position2);
            this.setHeight(this.left(position));
            this.setHeight(this.right(position));
            this.setHeight(position);
        }
    }

    @Override
    public V put(K k, V v) throws InvalidKeyException {
        V v2 = super.put(k, v);
        this.rebalance(this.actionPos);
        return v2;
    }

    @Override
    public V remove(K k) throws InvalidKeyException {
        Object v = super.remove(k);
        if (v != null) {
            this.rebalance(this.actionPos);
        }
        return v;
    }

    protected static class AVLNode<K, V>
    extends BTNode<Entry<K, V>> {
        protected int height;

        AVLNode() {
        }

        AVLNode(Entry<K, V> entry, BTPosition<Entry<K, V>> bTPosition, BTPosition<Entry<K, V>> bTPosition2, BTPosition<Entry<K, V>> bTPosition3) {
            super(entry, bTPosition, bTPosition2, bTPosition3);
            this.height = 0;
            if (bTPosition2 != null) {
                this.height = Math.max(this.height, 1 + ((AVLNode)bTPosition2).getHeight());
            }
            if (bTPosition3 != null) {
                this.height = Math.max(this.height, 1 + ((AVLNode)bTPosition3).getHeight());
            }
        }

        public void setHeight(int n) {
            this.height = n;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

