/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.util.Comparator;
import net.datastructures.BTNode;
import net.datastructures.BTPosition;
import net.datastructures.BinarySearchTree;
import net.datastructures.Dictionary;
import net.datastructures.Entry;
import net.datastructures.InvalidEntryException;
import net.datastructures.InvalidKeyException;
import net.datastructures.Position;

public class AVLTree<K, V>
extends BinarySearchTree<K, V>
implements Dictionary<K, V> {
    public AVLTree(Comparator<K> comparator) {
        super(comparator);
    }

    public AVLTree() {
    }

    @Override
    protected BTPosition<Entry<K, V>> createNode(Entry<K, V> entry, BTPosition<Entry<K, V>> bTPosition, BTPosition<Entry<K, V>> bTPosition2, BTPosition<Entry<K, V>> bTPosition3) {
        return new AVLNode<K, V>(entry, bTPosition, bTPosition2, bTPosition3);
    }

    protected int height(Position<Entry<K, V>> position) {
        return ((AVLNode)position).getHeight();
    }

    protected void setHeight(Position<Entry<K, V>> position) {
        ((AVLNode)position).setHeight(1 + Math.max(this.height(this.left(position)), this.height(this.right(position))));
    }

    protected boolean isBalanced(Position<Entry<K, V>> position) {
        int n = this.height(this.left(position)) - this.height(this.right(position));
        return -1 <= n && n <= 1;
    }

    protected Position<Entry<K, V>> tallerChild(Position<Entry<K, V>> position) {
        if (this.height(this.left(position)) > this.height(this.right(position))) {
            return this.left(position);
        }
        if (this.height(this.left(position)) < this.height(this.right(position))) {
            return this.right(position);
        }
        if (this.isRoot(position)) {
            return this.left(position);
        }
        if (position == this.left(this.parent(position))) {
            return this.left(position);
        }
        return this.right(position);
    }

    protected void rebalance(Position<Entry<K, V>> position) {
        if (this.isInternal(position)) {
            this.setHeight(position);
        }
        while (!this.isRoot(position)) {
            position = this.parent(position);
            this.setHeight(position);
            if (this.isBalanced(position)) continue;
            Position<Entry<K, V>> position2 = this.tallerChild(this.tallerChild(position));
            position = this.restructure(position2);
            this.setHeight(this.left(position));
            this.setHeight(this.right(position));
            this.setHeight(position);
        }
    }

    @Override
    public Entry<K, V> insert(K k, V v) throws InvalidKeyException {
        Entry<K, V> entry = super.insert(k, v);
        this.rebalance(this.actionPos);
        return entry;
    }

    @Override
    public Entry<K, V> remove(Entry<K, V> entry) throws InvalidEntryException {
        Entry<K, V> entry2 = super.remove(entry);
        if (entry2 != null) {
            this.rebalance(this.actionPos);
        }
        return entry2;
    }

    protected static class AVLNode<K, V>
    extends BTNode<Entry<K, V>> {
        protected int height;

        AVLNode() {
        }

        AVLNode(Entry<K, V> entry, BTPosition<Entry<K, V>> bTPosition, BTPosition<Entry<K, V>> bTPosition2, BTPosition<Entry<K, V>> bTPosition3) {
            super(entry, bTPosition, bTPosition2, bTPosition3);
            this.height = 0;
            if (bTPosition2 != null) {
                this.height = Math.max(this.height, 1 + ((AVLNode)bTPosition2).getHeight());
            }
            if (bTPosition3 != null) {
                this.height = Math.max(this.height, 1 + ((AVLNode)bTPosition3).getHeight());
            }
        }

        public void setHeight(int n) {
            this.height = n;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

